'use strict';

angular.module('reports_model', ['configuration_model'])
    .factory('Report', ['$http', '$rootScope', 'Configuration', function($http, $rootScope, Configuration){
        function Report(data){
            this.setData(data);
        }

        Report.prototype = {
            _bought: false
            ,_checked: false
            ,setData: function(data){
                angular.extend(this, data);
                this._originalValue = angular.copy(this.value);
            }
            ,isBought: function(){
                return this._bought;
            }
            ,isChecked: function(){
                return this._checked;
            }
            ,setChecked: function(checked){
                this._checked = checked;
            }
            ,save: function(callbackSuccess, callbackError){
                var scope = this;
                $http.post(Configuration.urlReports, this)
                    .success(function(data){
                        callbackSuccess(data);
                        scope._bought = true;
                        scope._checked = false;
                    })
                    .error(function(data){
                        callbackError(data);
                        scope._bought = false;
                        scope._checked = false;
                    })
                ;
            }

        }

        return Report;
    }])
    .factory('ReportsList', ['$http', '$q', 'Configuration', 'Report', function($http, $q, Configuration, Report){
        var ReportsList = {
            _isLoadedData: false
            ,_list: []
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this._list;
                }

                var defer = $q.defer();
                var scope = this;

                $http.get(Configuration.urlReports)
                    .success(function(data){
                        scope._list = [];
                        data.availableOfferReports.forEach(function(reportData){
                            reportData._bought = (data.boughtIds.indexOf(reportData.id) > -1);
                            scope._list.push(new Report(reportData));
                        });
                        scope._isLoadedData = true;
                        defer.resolve(scope._list);
                    })
                    .error(function(data){
                        defer.reject();
                    })
                ;

                return defer.promise;
            }
            ,isAnyToBuy: function(){
                var isToBuy = false;
                for(var i = 0; i < this._list.length; i++)
                {
                    if(!this._list[i].isBought())
                    {
                        isToBuy = true;
                        break;
                    }
                }

                return isToBuy;
            }
            ,isAnyBought: function(){
                var isBought = false;
                for(var i = 0; i < this._list.length; i++)
                {
                    if(this._list[i].isBought())
                    {
                        isBought = true;
                        break;
                    }
                }

                return isBought;
            }
        };

        return ReportsList;
    }])
;